#!/bin/sh
#
# $Header: opsm/cvutl/pluggable/ora_07445_errors_analyzer.sh /main/2 2011/01/12 18:13:46 nvira Exp $
#
# ora_07445_errors_analyzer.sh
#
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ora_07445_errors_analyzer.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nvira       10/27/10 - script to check 07445 errors
#    nvira       10/27/10 - Creation
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin


SGREP="grep"
SAWK="awk"
SCUT="cut"
SCAT="cat"

PLATFORM=`/bin/uname`

case $PLATFORM in
  Linux)
      _HOST=`/bin/hostname`
  ;;
  SunOS | HP-UX | AIX)
      _HOST=`/usr/bin/hostname`
  ;;
  
esac

# Set default exit message to indicate failure.
 result="<RESULT>EFAIL</RESULT><EXEC_ERROR>Error while checking for ORA-07445 errors in alert log</EXEC_ERROR><TRACE>Error while checking for ORA-07445 errors in alert log</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2924</ID><MSG_DATA><DATA>$dbName</DATA></MSG_DATA></NLS_MSG>"
existstatus=3
dbName=$1
expectedCount=$2
analyzerFileList=$3

count=0
ret=0

analyzerPath=$(/bin/sh -c "$SGREP PATH $analyzerFileList | $SAWK -F= '{print \$2}'")
analyzerFileName=$(/bin/sh -c "$SGREP GLOBAL $analyzerFileList | $SAWK -F= '{print \$2}'")

analyzerFile=$analyzerPath/$analyzerFileName

resultSet="<RESULTSET>"

existstatus=0

while read LINE
do
  if [ "x$LINE" != "x" ]
  then
    alert_dest=`echo "$LINE" | $SAWK '{print $2}'`
    instance_id=`echo "$LINE" | $SAWK '{print $1}'`
    instance_id=${dbName}"("${instance_id}")"
    tempCount=0
    count=0
    
    for alert_name in $(find "$alert_dest" -name 'alert_*.log' 2>/dev/null)
    do
      command="grep -i 'ORA-07445' $alert_name|wc -l"
      tempCount=$(/bin/sh -c "$command")
      ret=$?
      count=$(($count+$tempCount))
    done

    if [ $ret -eq 0 ]
    then
      if [ $count -le $expectedCount ]
        then
          resultSet=${resultSet}"<RESULT><STATUS>SUCC</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>No ORA-07445 errors found in alert log</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2922</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
      else
          resultSet=${resultSet}"<RESULT><STATUS>VFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><COLLECTED>$count</COLLECTED><EXPECTED>$expectedCount</EXPECTED><TRACE>ORA-07445 errors found in alert log</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2923</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
      fi   
    else
      resultSet=${resultSet}"<RESULT><STATUS>EFAIL</STATUS><ROW_ID>$instance_id</ROW_ID><EXEC_ERROR>Error while checking for ORA-07445 errors in alert log</EXEC_ERROR><TRACE>Error while checking for ORA-07445 errors in alert log</TRACE><NLS_MSG><FACILITY>Prve</FACILITY><ID>2924</ID><MSG_DATA><DATA>$instance_id</DATA></MSG_DATA></NLS_MSG></RESULT>"
    fi   
  fi
done <$analyzerFile


resultSet=${resultSet}"</RESULTSET>"

echo $resultSet
exit $existstatus
